/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import icyllis.modernui.core.forge.NetMessages;
import icyllis.modernui.core.forge.ServerHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;

public final class MuiHooks {
    private MuiHooks() {
    }

    public static boolean isServerStarted() {
        return ServerHandler.INSTANCE.started;
    }

    public static void openMenu(@Nonnull PlayerEntity player, @Nonnull IContainerProvider provider) {
        MuiHooks.openMenu((ServerPlayerEntity)player, provider, (Consumer<PacketBuffer>)null);
    }

    public static void openMenu(@Nonnull PlayerEntity player, @Nonnull IContainerProvider provider, @Nonnull BlockPos pos) {
        MuiHooks.openMenu((ServerPlayerEntity)player, provider, (PacketBuffer buf) -> buf.func_179255_a(pos));
    }

    public static void openMenu(@Nonnull PlayerEntity player, @Nonnull IContainerProvider provider, @Nullable Consumer<PacketBuffer> writer) {
        MuiHooks.openMenu((ServerPlayerEntity)player, provider, writer);
    }

    public static void openMenu(@Nonnull ServerPlayerEntity player, @Nonnull IContainerProvider provider, @Nullable Consumer<PacketBuffer> writer) {
        if (player.field_71070_bA != player.field_71069_bz) {
            player.func_71053_j();
        }
        player.func_71117_bO();
        int containerId = player.field_71139_cq;
        Container menu = provider.createMenu(containerId, player.field_71071_by, (PlayerEntity)player);
        if (menu == null) {
            return;
        }
        NetMessages.menu(containerId, Registry.field_218366_G.func_148757_b((Object)menu.func_216957_a()), writer).sendToPlayer(player);
        menu.func_75132_a((IContainerListener)player);
        player.field_71070_bA = menu;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, menu));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class C {
        private C() {
        }

        public static int calcGuiScales() {
            return C.calcGuiScales(Minecraft.func_71410_x().func_228018_at_());
        }

        public static int calcGuiScales(@Nonnull MainWindow window) {
            return C.calcGuiScales(window.func_198109_k(), window.func_198091_l());
        }

        public static int calcGuiScales(int framebufferWidth, int framebufferHeight) {
            int best;
            int i;
            int j;
            int w = framebufferWidth / 16;
            int h2 = framebufferHeight / 9;
            if ((w & 1) == 1) {
                ++w;
            }
            if ((h2 & 1) == 1) {
                ++h2;
            }
            double base = Math.min(w, h2);
            double high = Math.max(w, h2);
            int max = MathHelper.func_76125_a((int)((int)(base / 26.0)), (int)1, (int)6);
            int min2 = max > 1 ? MathHelper.func_76125_a((int)((j = (int)(high / 64.0)) != (i = (int)(base / 64.0)) ? Math.min(i, j) + 1 : i), (int)2, (int)6) : 1;
            if (min2 > 1) {
                double b = base > 150.0 ? 40.0 : (base > 100.0 ? 36.0 : 32.0);
                int i2 = (int)(base / b);
                int j2 = (int)(high / b);
                double v1 = base / (double)(i2 * 32);
                best = v1 > 1.25 || j2 > i2 ? Math.min(max, i2 + 1) : Math.min(max, i2);
            } else {
                best = 1;
            }
            return min2 << 8 | best << 4 | max;
        }
    }
}

